require "Wherigo"
ZonePoint = Wherigo.ZonePoint
Distance = Wherigo.Distance
Player = Wherigo.Player

-- #Author Directives Go Here# --
-- #End Author Directives# --

cartWherigoNightcaching = Wherigo.ZCartridge()

-- MessageBox Callback Functions Table used by the Builder --
cartWherigoNightcaching.MsgBoxCBFuncs = {}

zmediaBoar = Wherigo.ZMedia(cartWherigoNightcaching)
zmediaBoar.Name="Boar"
zmediaBoar.Description=""
zmediaBoar.AltText=""
zmediaBoar.Id="cff45486-5ffd-4670-9bb5-996246083d35"
zmediaBoar.Resources = {
{ Type = "jpg", Filename = "wildboar.JPG", Directives = {},},
}
zmediaRattlesnake = Wherigo.ZMedia(cartWherigoNightcaching)
zmediaRattlesnake.Name="Rattlesnake"
zmediaRattlesnake.Description=""
zmediaRattlesnake.AltText=""
zmediaRattlesnake.Id="4a7045b6-fbae-48ff-965b-0703be005fb0"
zmediaRattlesnake.Resources = {
{ Type = "jpg", Filename = "Eastern_Diamondback_Rattlesnake.jpg", Directives = {},},
}
zmediaMoccasin = Wherigo.ZMedia(cartWherigoNightcaching)
zmediaMoccasin.Name="Moccasin"
zmediaMoccasin.Description=""
zmediaMoccasin.AltText=""
zmediaMoccasin.Id="8c353b88-3056-4283-8ac5-1d524f29b291"
zmediaMoccasin.Resources = {
{ Type = "jpg", Filename = "cottonmouth.jpg", Directives = {},},
}
zmediaEyes = Wherigo.ZMedia(cartWherigoNightcaching)
zmediaEyes.Name="Eyes"
zmediaEyes.Description=""
zmediaEyes.AltText=""
zmediaEyes.Id="0fbb3ccd-f720-4a02-a511-189b03b1866f"
zmediaEyes.Resources = {
{ Type = "jpg", Filename = "cat eyes.jpg", Directives = {},},
}
zmediaSkulls = Wherigo.ZMedia(cartWherigoNightcaching)
zmediaSkulls.Name="Skulls"
zmediaSkulls.Description=""
zmediaSkulls.AltText=""
zmediaSkulls.Id="c9523a39-e219-4eb7-be29-673dd02d791d"
zmediaSkulls.Resources = {
{ Type = "jpg", Filename = "skulls.jpg", Directives = {},},
}
zmediaMoon = Wherigo.ZMedia(cartWherigoNightcaching)
zmediaMoon.Name="Moon"
zmediaMoon.Description=""
zmediaMoon.AltText=""
zmediaMoon.Id="6e16d99e-9209-45e9-8107-f4218f10a5a5"
zmediaMoon.Resources = {
{ Type = "jpg", Filename = "full_moon_02_20001.jpg", Directives = {},},
}
zmediaPanther = Wherigo.ZMedia(cartWherigoNightcaching)
zmediaPanther.Name="Panther"
zmediaPanther.Description=""
zmediaPanther.AltText=""
zmediaPanther.Id="cf7793a6-5430-44f5-927b-15e138657010"
zmediaPanther.Resources = {
{ Type = "jpg", Filename = "panther.jpg", Directives = {},},
}
zmediaGator = Wherigo.ZMedia(cartWherigoNightcaching)
zmediaGator.Name="Gator"
zmediaGator.Description=""
zmediaGator.AltText=""
zmediaGator.Id="80a93122-c3c9-41c5-b31f-589c7879f296"
zmediaGator.Resources = {
{ Type = "jpg", Filename = "alligatorL_468x343.jpg", Directives = {},},
}
zmediaVulture = Wherigo.ZMedia(cartWherigoNightcaching)
zmediaVulture.Name="Vulture"
zmediaVulture.Description=""
zmediaVulture.AltText=""
zmediaVulture.Id="b16b847c-b3c0-4691-ae01-1012d1adf02a"
zmediaVulture.Resources = {
{ Type = "jpg", Filename = "turkey-vulture2.jpg", Directives = {},},
}
-- Cartridge Info --
cartWherigoNightcaching.Id="120b2ed3-a700-4019-b478-4d90f7d304e6"
cartWherigoNightcaching.Name="Wherigo Nightcaching"
cartWherigoNightcaching.Description=[[This cartridge is a companion to the geocache by the same name. GC22BP5 This quest takes you on a 4 mile hike, 2.5 miles of which are pure, old school bushwhacking, through many varied environments, and it does it at night, in the Lil Big Econ State Forest. At times, you will need to resort to tools other than a Wherigo compatable device. These tools include a second, separate GPSr, and a compass. Things you will also need include a strong flashlight, a headlamp, a spare flashlight, spare batteries, clothing which can survive everything from head high saw palmettos to knee deep swamps, a pokey stick, bug spray, lots of water, first aid stuff and a cell phone. You should come prepared to be face to face with deer, raccoons, armadillos, venomous snakes and wild hogs. You should keep both your GPSr and your Wherigo device running, at all times. If you keep your tracklog on, on your GPSr, you will be glad you did later. Don't get eaten!]]
cartWherigoNightcaching.Visible=true
cartWherigoNightcaching.Activity="Geocache"
cartWherigoNightcaching.StartingLocationDescription=[[The parking lot of the Lil Big Econ State Forest, Barr St Trailhead, off County Rd 426, between Oviedo and Geneva]]
cartWherigoNightcaching.StartingLocation = ZonePoint(28.68701,-81.159599,0)
cartWherigoNightcaching.Version="1"
cartWherigoNightcaching.Company=""
cartWherigoNightcaching.Author="Clan Riffster"
cartWherigoNightcaching.BuilderVersion="2.0.5129.5086"
cartWherigoNightcaching.CreateDate="11/3/2010 8:20:06 PM"
cartWherigoNightcaching.PublishDate="1/1/0001 12:00:00 AM"
cartWherigoNightcaching.UpdateDate="11/10/2010 12:04:59 PM"
cartWherigoNightcaching.LastPlayedDate="1/1/0001 12:00:00 AM"
cartWherigoNightcaching.TargetDevice="PocketPC"
cartWherigoNightcaching.TargetDeviceVersion="0"
cartWherigoNightcaching.StateId="1"
cartWherigoNightcaching.CountryId="2"
cartWherigoNightcaching.Complete=false
cartWherigoNightcaching.UseLogging=false
cartWherigoNightcaching.Media=zmediaMoon

-- Zones --
zoneKiosk = Wherigo.Zone(cartWherigoNightcaching)
zoneKiosk.Id="7426ad1a-efcf-408c-99e6-67deda8f10b2"
zoneKiosk.Name="Kiosk"
zoneKiosk.Description=[[Proceed east to the Kiosk just inside the pedestrian entrance]]
zoneKiosk.Visible=true
zoneKiosk.DistanceRange = Distance(-1, "feet")
zoneKiosk.ShowObjects="OnEnter"
zoneKiosk.ProximityRange = Distance(200, "feet")
zoneKiosk.AllowSetPositionTo=false
zoneKiosk.Active=true
zoneKiosk.Points = {
  ZonePoint(28.68747,-81.15931,0),
  ZonePoint(28.68747,-81.15919,0),
  ZonePoint(28.68737,-81.15919,0),
  ZonePoint(28.68737,-81.15931,0)
}
zoneKiosk.OriginalPoint = ZonePoint(28.687417,-81.15925,0)
zoneKiosk.DistanceRangeUOM = "Feet"
zoneKiosk.ProximityRangeUOM = "Feet"
zoneKiosk.OutOfRangeName = ""
zoneKiosk.InRangeName = ""
zoneKiosk.Media=zmediaVulture

zoneAmmoCan1 = Wherigo.Zone(cartWherigoNightcaching)
zoneAmmoCan1.Id="d4a9065d-b3cb-45ea-b4a3-4d9a7631b8b4"
zoneAmmoCan1.Name="Ammo Can 1"
zoneAmmoCan1.Description=[[Proceed east from the kiosk. Follow the trail close to the river, then head north as you get closer. I've included a waypoint on the cache page for the easiest entry point into the flora. You'll need to bushwhack from there]]
zoneAmmoCan1.Visible=false
zoneAmmoCan1.DistanceRange = Distance(1300, "meters")
zoneAmmoCan1.ShowObjects="OnEnter"
zoneAmmoCan1.ProximityRange = Distance(200, "feet")
zoneAmmoCan1.AllowSetPositionTo=false
zoneAmmoCan1.Active=false
zoneAmmoCan1.Points = {
  ZonePoint(28.68646,-81.14743,0),
  ZonePoint(28.68646,-81.14721,0),
  ZonePoint(28.68627,-81.14721,0),
  ZonePoint(28.68627,-81.14743,0)
}
zoneAmmoCan1.OriginalPoint = ZonePoint(28.686367,-81.147317,0)
zoneAmmoCan1.DistanceRangeUOM = "Meters"
zoneAmmoCan1.ProximityRangeUOM = "Feet"
zoneAmmoCan1.OutOfRangeName = ""
zoneAmmoCan1.InRangeName = ""
zoneAmmoCan1.Media=zmediaBoar

zoneTrailEnd1 = Wherigo.Zone(cartWherigoNightcaching)
zoneTrailEnd1.Id="0e91879b-65e3-4de2-8ec7-660677d8110d"
zoneTrailEnd1.Name="Trail End 1"
zoneTrailEnd1.Description=[[Locate three reflectors, placed in a triangle formation. Once you see those, you'll be in the Trail 1 End zone. Trigger the zone for further instructions]]
zoneTrailEnd1.Visible=false
zoneTrailEnd1.DistanceRange = Distance(100, "meters")
zoneTrailEnd1.ShowObjects="OnEnter"
zoneTrailEnd1.ProximityRange = Distance(200, "feet")
zoneTrailEnd1.AllowSetPositionTo=false
zoneTrailEnd1.Active=false
zoneTrailEnd1.Points = {
  ZonePoint(28.68722,-81.1444,0),
  ZonePoint(28.68722,-81.14418,0),
  ZonePoint(28.68703,-81.14418,0),
  ZonePoint(28.68703,-81.1444,0)
}
zoneTrailEnd1.OriginalPoint = ZonePoint(28.687125,-81.144294,0)
zoneTrailEnd1.DistanceRangeUOM = "Meters"
zoneTrailEnd1.ProximityRangeUOM = "Feet"
zoneTrailEnd1.OutOfRangeName = ""
zoneTrailEnd1.InRangeName = ""

zoneAmmoCan2 = Wherigo.Zone(cartWherigoNightcaching)
zoneAmmoCan2.Id="02b5c0a9-ac90-48e5-9502-bf983e37139a"
zoneAmmoCan2.Name="Ammo Can 2"
zoneAmmoCan2.Description=[[This would be a good opportunity to utilize your second GPSr, proceeding roughly 3/10 mile on a bearing of 075*, to N28* 41.296 / W81* 08.351, where you'll find a second ammo can. As you are bushwhacking along, you might pass through another reflector trail. Feel free to ignore it for now. You should keep your Wherigo GPSr running as you go, as you will trigger another zone when you get there]]
zoneAmmoCan2.Visible=false
zoneAmmoCan2.DistanceRange = Distance(550, "meters")
zoneAmmoCan2.ShowObjects="OnEnter"
zoneAmmoCan2.ProximityRange = Distance(200, "feet")
zoneAmmoCan2.AllowSetPositionTo=false
zoneAmmoCan2.Active=false
zoneAmmoCan2.Points = {
  ZonePoint(28.68836,-81.13929,0),
  ZonePoint(28.68836,-81.13907,0),
  ZonePoint(28.68817,-81.13907,0),
  ZonePoint(28.68817,-81.13929,0)
}
zoneAmmoCan2.OriginalPoint = ZonePoint(28.688267,-81.139183,0)
zoneAmmoCan2.DistanceRangeUOM = "Meters"
zoneAmmoCan2.ProximityRangeUOM = "Feet"
zoneAmmoCan2.OutOfRangeName = ""
zoneAmmoCan2.InRangeName = ""
zoneAmmoCan2.Media=zmediaRattlesnake

zoneTrailEnd2 = Wherigo.Zone(cartWherigoNightcaching)
zoneTrailEnd2.Id="ec116ebd-9b58-44d5-b3eb-cb2954c53f61"
zoneTrailEnd2.Name="Trail End 2"
zoneTrailEnd2.Description=[[As you meander along, casually dodging all manner of nasty critters, you should keep an eye out for three reflectors, placed in a triangle formation. Once you see those, you'll be in the Trail 2 End zone. Trigger the zone for further instructions]]
zoneTrailEnd2.Visible=false
zoneTrailEnd2.DistanceRange = Distance(100, "meters")
zoneTrailEnd2.ShowObjects="OnEnter"
zoneTrailEnd2.ProximityRange = Distance(200, "feet")
zoneTrailEnd2.AllowSetPositionTo=false
zoneTrailEnd2.Active=false
zoneTrailEnd2.Points = {
  ZonePoint(28.68634,-81.14133,0),
  ZonePoint(28.68634,-81.1411,0),
  ZonePoint(28.68614,-81.1411,0),
  ZonePoint(28.68614,-81.14133,0)
}
zoneTrailEnd2.OriginalPoint = ZonePoint(28.686238,-81.141215,0)
zoneTrailEnd2.DistanceRangeUOM = "Meters"
zoneTrailEnd2.ProximityRangeUOM = "Feet"
zoneTrailEnd2.OutOfRangeName = ""
zoneTrailEnd2.InRangeName = ""

zoneAmmoCan3 = Wherigo.Zone(cartWherigoNightcaching)
zoneAmmoCan3.Id="925ac85d-1e49-4f3e-91b7-6fbe789e4f0a"
zoneAmmoCan3.Name="Ammo Can 3"
zoneAmmoCan3.Description=[[As you leave the second reflector trail behind, you would be wise to switch over to your regular GPSr, proceeding roughly 3/10 mile on a bearing of 218*, to N28* 40.973 / W81* 08.659, where you'll find a third ammo can. As you are staggering through the deep shrubbery, wondering just what the heck you are doing out here, you might pass through another reflector trail. Feel free to ignore it for now. You should keep your Wherigo GPSr running as you go, as you will trigger another zone when you get there]]
zoneAmmoCan3.Visible=false
zoneAmmoCan3.DistanceRange = Distance(550, "meters")
zoneAmmoCan3.ShowObjects="OnEnter"
zoneAmmoCan3.ProximityRange = Distance(200, "feet")
zoneAmmoCan3.AllowSetPositionTo=false
zoneAmmoCan3.Active=false
zoneAmmoCan3.Points = {
  ZonePoint(28.68298,-81.14443,0),
  ZonePoint(28.68298,-81.14421,0),
  ZonePoint(28.68279,-81.14421,0),
  ZonePoint(28.68279,-81.14443,0)
}
zoneAmmoCan3.OriginalPoint = ZonePoint(28.682883,-81.144317,0)
zoneAmmoCan3.DistanceRangeUOM = "Meters"
zoneAmmoCan3.ProximityRangeUOM = "Feet"
zoneAmmoCan3.OutOfRangeName = ""
zoneAmmoCan3.InRangeName = ""
zoneAmmoCan3.Media=zmediaMoccasin

zoneTrailEnd3 = Wherigo.Zone(cartWherigoNightcaching)
zoneTrailEnd3.Id="49db3ffb-4027-4409-b018-9fa65f31d793"
zoneTrailEnd3.Name="Trail End 3"
zoneTrailEnd3.Description=[[As you are stumbling about, following reflectors, keep an eye out for three reflectors, placed in a triangle formation. Once you see those, you'll be in the Trail 3 End zone. Trigger the zone for further instructions]]
zoneTrailEnd3.Visible=false
zoneTrailEnd3.DistanceRange = Distance(100, "meters")
zoneTrailEnd3.ShowObjects="OnEnter"
zoneTrailEnd3.ProximityRange = Distance(200, "feet")
zoneTrailEnd3.AllowSetPositionTo=false
zoneTrailEnd3.Active=false
zoneTrailEnd3.Points = {
  ZonePoint(28.6856,-81.14434,0),
  ZonePoint(28.6856,-81.14412,0),
  ZonePoint(28.6854,-81.14412,0),
  ZonePoint(28.6854,-81.14434,0)
}
zoneTrailEnd3.OriginalPoint = ZonePoint(28.6855,-81.144233,0)
zoneTrailEnd3.DistanceRangeUOM = "Meters"
zoneTrailEnd3.ProximityRangeUOM = "Feet"
zoneTrailEnd3.OutOfRangeName = ""
zoneTrailEnd3.InRangeName = ""

zoneAmmoCan4 = Wherigo.Zone(cartWherigoNightcaching)
zoneAmmoCan4.Id="ee0d89bc-6380-4075-9d53-4386398e9112"
zoneAmmoCan4.Name="Ammo Can 4"
zoneAmmoCan4.Description=[[Are you tired yet? The end of this quest draws ever closer. A clever Hobbit will switch over to their other GPSr, proceeding roughly 3/10 mile on a bearing of 003*, to N28* 41.381 / W81* 08.649, where you'll find a fourth ammo can. You will undoubtedly stumble through another reflector trail. Feel free to ignore it for now. You should keep your Wherigo GPSr running as you go, as you will trigger another zone when you get there]]
zoneAmmoCan4.Visible=false
zoneAmmoCan4.DistanceRange = Distance(550, "meters")
zoneAmmoCan4.ShowObjects="OnEnter"
zoneAmmoCan4.ProximityRange = Distance(200, "feet")
zoneAmmoCan4.AllowSetPositionTo=false
zoneAmmoCan4.Active=false
zoneAmmoCan4.Points = {
  ZonePoint(28.68978,-81.14426,0),
  ZonePoint(28.68978,-81.14404,0),
  ZonePoint(28.68959,-81.14404,0),
  ZonePoint(28.68959,-81.14426,0)
}
zoneAmmoCan4.OriginalPoint = ZonePoint(28.689683,-81.14415,0)
zoneAmmoCan4.DistanceRangeUOM = "Meters"
zoneAmmoCan4.ProximityRangeUOM = "Feet"
zoneAmmoCan4.OutOfRangeName = ""
zoneAmmoCan4.InRangeName = ""
zoneAmmoCan4.Media=zmediaEyes

zoneTrailEnd4 = Wherigo.Zone(cartWherigoNightcaching)
zoneTrailEnd4.Id="59625afc-3df5-4257-9421-82f5e3ac7057"
zoneTrailEnd4.Name="Trail End 4"
zoneTrailEnd4.Description=[[Are you freekin' kidding me? Another reflector trail? ugh! Might as well get on with it. Keep going till you find three reflectors, placed in a triangle formation. Once you see those, you'll be in the Trail 4 End zone. Trigger the zone for further instructions]]
zoneTrailEnd4.Visible=false
zoneTrailEnd4.DistanceRange = Distance(100, "meters")
zoneTrailEnd4.ShowObjects="OnEnter"
zoneTrailEnd4.ProximityRange = Distance(200, "feet")
zoneTrailEnd4.AllowSetPositionTo=false
zoneTrailEnd4.Active=false
zoneTrailEnd4.Points = {
  ZonePoint(28.68764,-81.14246,0),
  ZonePoint(28.68764,-81.14224,0),
  ZonePoint(28.68745,-81.14224,0),
  ZonePoint(28.68745,-81.14246,0)
}
zoneTrailEnd4.OriginalPoint = ZonePoint(28.687545,-81.142352,0)
zoneTrailEnd4.DistanceRangeUOM = "Meters"
zoneTrailEnd4.ProximityRangeUOM = "Feet"
zoneTrailEnd4.OutOfRangeName = ""
zoneTrailEnd4.InRangeName = ""

zoneAmmoCan5 = Wherigo.Zone(cartWherigoNightcaching)
zoneAmmoCan5.Id="1199af07-70bd-4c0f-980a-99b433c1c538"
zoneAmmoCan5.Name="Ammo Can 5"
zoneAmmoCan5.Description=[[Once more into the breech! Switch over to your other GPSr, proceeding roughly 3/10 mile on a bearing of 145*, to N28* 40.044 / W81* 08.372, where you'll find the fifth ammo can. Along the way, you will see another reflector trail. Feel free to ignore it for now. You should keep your Wherigo GPSr running as you go, as you will trigger another zone when you get there]]
zoneAmmoCan5.Visible=false
zoneAmmoCan5.DistanceRange = Distance(550, "meters")
zoneAmmoCan5.ShowObjects="OnEnter"
zoneAmmoCan5.ProximityRange = Distance(200, "feet")
zoneAmmoCan5.AllowSetPositionTo=false
zoneAmmoCan5.Active=false
zoneAmmoCan5.Points = {
  ZonePoint(28.68416,-81.13964,0),
  ZonePoint(28.68416,-81.13942,0),
  ZonePoint(28.68397,-81.13942,0),
  ZonePoint(28.68397,-81.13964,0)
}
zoneAmmoCan5.OriginalPoint = ZonePoint(28.684067,-81.139533,0)
zoneAmmoCan5.DistanceRangeUOM = "Meters"
zoneAmmoCan5.ProximityRangeUOM = "Feet"
zoneAmmoCan5.OutOfRangeName = ""
zoneAmmoCan5.InRangeName = ""
zoneAmmoCan5.Media=zmediaSkulls

zoneTrailEnd5 = Wherigo.Zone(cartWherigoNightcaching)
zoneTrailEnd5.Id="bcd5c8af-a281-4591-8da2-ca27c27b1042"
zoneTrailEnd5.Name="Trail End 5"
zoneTrailEnd5.Description=[[Great. Another reflector trail. Sigh. Lets get it over with! Follow the trail until you come to three reflectors, placed in a triangle formation. Once you see those, you'll be in the Trail 5 End zone. Trigger the zone for further instructions]]
zoneTrailEnd5.Visible=false
zoneTrailEnd5.DistanceRange = Distance(100, "meters")
zoneTrailEnd5.ShowObjects="OnEnter"
zoneTrailEnd5.ProximityRange = Distance(200, "feet")
zoneTrailEnd5.AllowSetPositionTo=false
zoneTrailEnd5.Active=false
zoneTrailEnd5.Points = {
  ZonePoint(28.68512,-81.14243,0),
  ZonePoint(28.68512,-81.14221,0),
  ZonePoint(28.68493,-81.14221,0),
  ZonePoint(28.68493,-81.14243,0)
}
zoneTrailEnd5.OriginalPoint = ZonePoint(28.685024,-81.142323,0)
zoneTrailEnd5.DistanceRangeUOM = "Meters"
zoneTrailEnd5.ProximityRangeUOM = "Feet"
zoneTrailEnd5.OutOfRangeName = ""
zoneTrailEnd5.InRangeName = ""

zoneBacktoAmmoCan1 = Wherigo.Zone(cartWherigoNightcaching)
zoneBacktoAmmoCan1.Id="00577779-dbf6-451c-8f9d-7978cf9b6b49"
zoneBacktoAmmoCan1.Name="Back to Ammo Can 1"
zoneBacktoAmmoCan1.Description=[[As you blunder about, sweating and bleeding, with exhaustion oozing out of every pore, you can at least take solace in the fact that this is the last time you will have to bushwhack through this patch of Momma Nature. Switch over to your other GPSr, proceeding roughly 3/10 mile on a bearing of 288*, to N28* 41.182 / W81* 08.839, where you'll find the first ammo can. Along the way, you will see another reflector trail. Feel free to ignore it for now. You should keep your Wherigo GPSr running as you go, as you will trigger another zone when you get there]]
zoneBacktoAmmoCan1.Visible=false
zoneBacktoAmmoCan1.DistanceRange = Distance(550, "meters")
zoneBacktoAmmoCan1.ShowObjects="OnEnter"
zoneBacktoAmmoCan1.ProximityRange = Distance(200, "feet")
zoneBacktoAmmoCan1.AllowSetPositionTo=false
zoneBacktoAmmoCan1.Active=false
zoneBacktoAmmoCan1.Points = {
  ZonePoint(28.68646,-81.14743,0),
  ZonePoint(28.68646,-81.14721,0),
  ZonePoint(28.68627,-81.14721,0),
  ZonePoint(28.68627,-81.14743,0)
}
zoneBacktoAmmoCan1.OriginalPoint = ZonePoint(28.686367,-81.147317,0)
zoneBacktoAmmoCan1.DistanceRangeUOM = "Meters"
zoneBacktoAmmoCan1.ProximityRangeUOM = "Feet"
zoneBacktoAmmoCan1.OutOfRangeName = ""
zoneBacktoAmmoCan1.InRangeName = ""
zoneBacktoAmmoCan1.Media=zmediaPanther

zoneFinal = Wherigo.Zone(cartWherigoNightcaching)
zoneFinal.Id="5f843057-4a1e-45e5-8365-3e76af59581d"
zoneFinal.Name="Final"
zoneFinal.Description=[[From here, your easiest trek will be to go west till the trees thin out, then head north toward the waypoint. Proceed west to the second trail fork, then head south. Follow the river west for about half a mile, then turn north. Cross the foot bridge, duck under the tree, than look for a small trail that heads north, whilst the main trail goes west. Once the small trail peters out, bushwhack just a bit till you see the glow of a reflective ammo can. Since your journey was such an arduous one, the find will be a piece of cake.]]
zoneFinal.Visible=false
zoneFinal.DistanceRange = Distance(1000, "meters")
zoneFinal.ShowObjects="OnEnter"
zoneFinal.ProximityRange = Distance(200, "feet")
zoneFinal.AllowSetPositionTo=false
zoneFinal.Active=false
zoneFinal.Points = {
  ZonePoint(28.68814,-81.15724,0),
  ZonePoint(28.68814,-81.15702,0),
  ZonePoint(28.68795,-81.15702,0),
  ZonePoint(28.68795,-81.15724,0)
}
zoneFinal.OriginalPoint = ZonePoint(28.688046,-81.157132,0)
zoneFinal.DistanceRangeUOM = "Meters"
zoneFinal.ProximityRangeUOM = "Feet"
zoneFinal.OutOfRangeName = ""
zoneFinal.InRangeName = ""
zoneFinal.Media=zmediaGator

-- Characters --

-- Items --

-- Tasks --

-- Cartridge Variables --
TrailEnd1 = ""
AmmoCan2 = ""
AmmoCan1 = ""
TrailEnd2 = ""
TrailEnd4 = ""
TrailEnd3 = ""
Final = ""
AmmoCan3 = ""
TrailEnd5 = ""
AmmoCan4 = ""
BacktoAmmoCan1 = ""
AmmoCan5 = ""
Kiosk = ""
cartWherigoNightcaching.ZVariables = {TrailEnd1 = "", AmmoCan2 = "", AmmoCan1 = "", TrailEnd2 = "", TrailEnd4 = "", TrailEnd3 = "", Final = "", AmmoCan3 = "", TrailEnd5 = "", AmmoCan4 = "", BacktoAmmoCan1 = "", AmmoCan5 = "", Kiosk = ""}

-- Builder Variables (to be read by the builder only) --
buildervar = {}
buildervar.TrailEnd1 = {}
buildervar.TrailEnd1.Id ="6cb3b301-d21b-48e6-bb6a-4d31496e74c2"
buildervar.TrailEnd1.Name = "Trail End 1"
buildervar.TrailEnd1.Type = "String"
buildervar.TrailEnd1.Data=[[]]
buildervar.TrailEnd1.Description=[[]]

buildervar.AmmoCan2 = {}
buildervar.AmmoCan2.Id ="bd999723-294e-4561-987e-e576fddbfe4b"
buildervar.AmmoCan2.Name = "Ammo Can 2"
buildervar.AmmoCan2.Type = "String"
buildervar.AmmoCan2.Data=[[]]
buildervar.AmmoCan2.Description=[[]]

buildervar.AmmoCan1 = {}
buildervar.AmmoCan1.Id ="941dd534-cf34-48c2-a62a-d662c5953a48"
buildervar.AmmoCan1.Name = "Ammo Can 1"
buildervar.AmmoCan1.Type = "String"
buildervar.AmmoCan1.Data=[[]]
buildervar.AmmoCan1.Description=[[]]

buildervar.TrailEnd2 = {}
buildervar.TrailEnd2.Id ="30a3a2cf-36c7-45ee-8565-a3b286d21713"
buildervar.TrailEnd2.Name = "Trail End 2"
buildervar.TrailEnd2.Type = "String"
buildervar.TrailEnd2.Data=[[]]
buildervar.TrailEnd2.Description=[[]]

buildervar.TrailEnd4 = {}
buildervar.TrailEnd4.Id ="b46dddc8-b35b-45c1-9b0b-396306e3fbc6"
buildervar.TrailEnd4.Name = "Trail End 4"
buildervar.TrailEnd4.Type = "String"
buildervar.TrailEnd4.Data=[[]]
buildervar.TrailEnd4.Description=[[]]

buildervar.TrailEnd3 = {}
buildervar.TrailEnd3.Id ="31f18c51-e4e5-4151-bc0c-548d8a612a1a"
buildervar.TrailEnd3.Name = "Trail End 3"
buildervar.TrailEnd3.Type = "String"
buildervar.TrailEnd3.Data=[[]]
buildervar.TrailEnd3.Description=[[]]

buildervar.Final = {}
buildervar.Final.Id ="30fe37a8-ae69-482a-ae53-e56cff1a0fb4"
buildervar.Final.Name = "Final"
buildervar.Final.Type = "String"
buildervar.Final.Data=[[]]
buildervar.Final.Description=[[]]

buildervar.AmmoCan3 = {}
buildervar.AmmoCan3.Id ="1bef91b9-4a52-4d7c-bdce-ac052114b3f9"
buildervar.AmmoCan3.Name = "Ammo Can 3"
buildervar.AmmoCan3.Type = "String"
buildervar.AmmoCan3.Data=[[]]
buildervar.AmmoCan3.Description=[[]]

buildervar.TrailEnd5 = {}
buildervar.TrailEnd5.Id ="869bd539-3692-4969-a895-d9c3e332eb1b"
buildervar.TrailEnd5.Name = "Trail End 5"
buildervar.TrailEnd5.Type = "String"
buildervar.TrailEnd5.Data=[[]]
buildervar.TrailEnd5.Description=[[]]

buildervar.AmmoCan4 = {}
buildervar.AmmoCan4.Id ="a91e2c2d-c64b-470a-a4a3-ece1c29a6737"
buildervar.AmmoCan4.Name = "Ammo Can 4"
buildervar.AmmoCan4.Type = "String"
buildervar.AmmoCan4.Data=[[]]
buildervar.AmmoCan4.Description=[[]]

buildervar.BacktoAmmoCan1 = {}
buildervar.BacktoAmmoCan1.Id ="5ae0bf86-4c33-450f-b3ea-efff84c51a68"
buildervar.BacktoAmmoCan1.Name = "Back to Ammo Can 1"
buildervar.BacktoAmmoCan1.Type = "String"
buildervar.BacktoAmmoCan1.Data=[[]]
buildervar.BacktoAmmoCan1.Description=[[]]

buildervar.AmmoCan5 = {}
buildervar.AmmoCan5.Id ="20f1604c-41b5-4c83-b99f-163ad75f7168"
buildervar.AmmoCan5.Name = "Ammo Can 5"
buildervar.AmmoCan5.Type = "String"
buildervar.AmmoCan5.Data=[[]]
buildervar.AmmoCan5.Description=[[]]

buildervar.Kiosk = {}
buildervar.Kiosk.Id ="d0f30dd9-45d0-4ac7-93a5-0f89102b2d33"
buildervar.Kiosk.Name = "Kiosk"
buildervar.Kiosk.Type = "String"
buildervar.Kiosk.Data=[[]]
buildervar.Kiosk.Description=[[]]


-- ZTimers --

-- Inputs --
zinputKiosk = Wherigo.ZInput(cartWherigoNightcaching)
zinputKiosk.Id="d54c2659-8b63-43e0-a373-83c5ec784521"
zinputKiosk.Name="Kiosk"
zinputKiosk.Description=[[]]
zinputKiosk.Visible=true
zinputKiosk.InputType="Text"
zinputKiosk.InputVariableId="d0f30dd9-45d0-4ac7-93a5-0f89102b2d33"
zinputKiosk.Text=[[At the top of the kiosk display, there is a drawing of a bird. Enter the two words directly under the bird]]

zinputAmmoCan1 = Wherigo.ZInput(cartWherigoNightcaching)
zinputAmmoCan1.Id="e65bbbf8-200a-4209-a036-cde2587b30b0"
zinputAmmoCan1.Name="Ammo Can 1"
zinputAmmoCan1.Description=[[]]
zinputAmmoCan1.Visible=true
zinputAmmoCan1.InputType="Text"
zinputAmmoCan1.InputVariableId="941dd534-cf34-48c2-a62a-d662c5953a48"
zinputAmmoCan1.Text=[[If you need help solving the puzzle, head 30' on a bearing of 275*. Find a camo PVC pipe, and unscrew the bottom to reveal a clue. Once you solve the puzzle, enter the code word here]]

zinputTrailEnd1 = Wherigo.ZInput(cartWherigoNightcaching)
zinputTrailEnd1.Id="786ff138-6f0b-476d-8e58-67e4de895ed8"
zinputTrailEnd1.Name="Trail End 1"
zinputTrailEnd1.Description=[[]]
zinputTrailEnd1.Visible=true
zinputTrailEnd1.Choices = {"Hiipopoyumus", "Hippie", "Wild Hog", "Penguin"}
zinputTrailEnd1.InputType="MultipleChoice"
zinputTrailEnd1.InputVariableId="6cb3b301-d21b-48e6-bb6a-4d31496e74c2"
zinputTrailEnd1.Text=[[Considering the environment, which critter is most likely to kill you tonight?]]

zinputAmmoCan2 = Wherigo.ZInput(cartWherigoNightcaching)
zinputAmmoCan2.Id="a62371ee-ba58-4805-a20f-6e8ce68975f3"
zinputAmmoCan2.Name="Ammo Can 2"
zinputAmmoCan2.Description=[[]]
zinputAmmoCan2.Visible=true
zinputAmmoCan2.InputType="Text"
zinputAmmoCan2.InputVariableId="bd999723-294e-4561-987e-e576fddbfe4b"
zinputAmmoCan2.Text=[[To get help solving the puzzle, go 30' on a bearing of 111*. Yup. Another camo PVC pipe. Unscrew the bottom to reveal a clue. Once you solve the puzzle, enter the code word here]]

zinputTrailEnd2 = Wherigo.ZInput(cartWherigoNightcaching)
zinputTrailEnd2.Id="dadccfc5-3615-4b15-a9f0-e504c7d4194d"
zinputTrailEnd2.Name="Trail End 2"
zinputTrailEnd2.Description=[[]]
zinputTrailEnd2.Visible=true
zinputTrailEnd2.Choices = {"George Washington", "Abe Lincoln", "Rosie ODonnell", "Samuel Adams"}
zinputTrailEnd2.InputType="MultipleChoice"
zinputTrailEnd2.InputVariableId="30a3a2cf-36c7-45ee-8565-a3b286d21713"
zinputTrailEnd2.Text=[[Pick the Barking Moonbat from these characters]]

zinputAmmoCan3 = Wherigo.ZInput(cartWherigoNightcaching)
zinputAmmoCan3.Id="d86ac3a1-1911-4e7a-b0a4-4e070427cb12"
zinputAmmoCan3.Name="Ammo Can 3"
zinputAmmoCan3.Description=[[]]
zinputAmmoCan3.Visible=true
zinputAmmoCan3.InputType="Text"
zinputAmmoCan3.InputVariableId="1bef91b9-4a52-4d7c-bdce-ac052114b3f9"
zinputAmmoCan3.Text=[[Yes, there is help available. Hoof it 30' on a bearing of 184*.for another camo PVC pipe, and unscrew the bottom to reveal a clue. Once you solve the puzzle, enter the code word here]]

zinputTrailEnd3 = Wherigo.ZInput(cartWherigoNightcaching)
zinputTrailEnd3.Id="da7c3ef9-3374-4a5c-a64c-a6179f0fad3d"
zinputTrailEnd3.Name="Trail End 3"
zinputTrailEnd3.Description=[[]]
zinputTrailEnd3.Visible=true
zinputTrailEnd3.Choices = {"79", "154", "A Butt Load", "210"}
zinputTrailEnd3.InputType="MultipleChoice"
zinputTrailEnd3.InputVariableId="31f18c51-e4e5-4151-bc0c-548d8a612a1a"
zinputTrailEnd3.Text=[[How many reflectors have you passed during this quest?]]

zinputAmmoCan4 = Wherigo.ZInput(cartWherigoNightcaching)
zinputAmmoCan4.Id="59b48eb0-8b67-4c0a-915c-3cd16ffc4ff4"
zinputAmmoCan4.Name="Ammo Can 4"
zinputAmmoCan4.Description=[[]]
zinputAmmoCan4.Visible=true
zinputAmmoCan4.InputType="Text"
zinputAmmoCan4.InputVariableId="a91e2c2d-c64b-470a-a4a3-ece1c29a6737"
zinputAmmoCan4.Text=[[Is your brain melting? Need help solving the puzzle? Head 40' on a bearing of 234*. Find a camo PVC pipe, and unscrew the bottom to reveal a clue. Once you solve the puzzle, enter the code word here]]

zinputTrailEnd4 = Wherigo.ZInput(cartWherigoNightcaching)
zinputTrailEnd4.Id="c168a738-45bd-4ada-812d-8049588e09f5"
zinputTrailEnd4.Name="Trail End 4"
zinputTrailEnd4.Description=[[]]
zinputTrailEnd4.Visible=true
zinputTrailEnd4.Choices = {"Mosquito", "Fire Ant", "Bureaucrat", "Flea"}
zinputTrailEnd4.InputType="MultipleChoice"
zinputTrailEnd4.InputVariableId="b46dddc8-b35b-45c1-9b0b-396306e3fbc6"
zinputTrailEnd4.Text=[[Which of these four critters would even the most radical environmentalist accept going extinct?]]

zinputAmmoCan5 = Wherigo.ZInput(cartWherigoNightcaching)
zinputAmmoCan5.Id="25eb919a-1664-4cc0-8928-e27253dc6943"
zinputAmmoCan5.Name="Ammo Can 5"
zinputAmmoCan5.Description=[[]]
zinputAmmoCan5.Visible=true
zinputAmmoCan5.InputType="Text"
zinputAmmoCan5.InputVariableId="20f1604c-41b5-4c83-b99f-163ad75f7168"
zinputAmmoCan5.Text=[[Do I really need to say it? Fine. Go 35' on a bearing of 157*. Find a camo PVC pipe, and unscrew the bottom to reveal a clue to solve the puzzle. Happy? Once you solve the puzzle, enter the code word here]]

zinputTrailEnd5 = Wherigo.ZInput(cartWherigoNightcaching)
zinputTrailEnd5.Id="85fc78b5-8463-4566-bbe9-1011f57dc666"
zinputTrailEnd5.Name="Trail End 5"
zinputTrailEnd5.Description=[[]]
zinputTrailEnd5.Visible=true
zinputTrailEnd5.Choices = {"Hemorrhoids", "DHSMV Clerks", "Beer", "Crying Children"}
zinputTrailEnd5.InputType="MultipleChoice"
zinputTrailEnd5.InputVariableId="869bd539-3692-4969-a895-d9c3e332eb1b"
zinputTrailEnd5.Text=[[According to caching legend Chief Talking Bull, Life goes better with]]

zinputBacktoAmmoCan1 = Wherigo.ZInput(cartWherigoNightcaching)
zinputBacktoAmmoCan1.Id="4a9903da-849b-4d5e-ae1c-218066e2916f"
zinputBacktoAmmoCan1.Name="Back to Ammo Can 1"
zinputBacktoAmmoCan1.Description=[[]]
zinputBacktoAmmoCan1.Visible=true
zinputBacktoAmmoCan1.InputType="Text"
zinputBacktoAmmoCan1.InputVariableId="5ae0bf86-4c33-450f-b3ea-efff84c51a68"
zinputBacktoAmmoCan1.Text=[[Holy Carp! Are we done yet? I've got bug bites on my bug bites, for Gaia's sake! Open the first ammo can up, and enter the first word you see that is written in red]]

zinputFinal = Wherigo.ZInput(cartWherigoNightcaching)
zinputFinal.Id="9b9b4136-61c1-428d-9b15-f9be1c16b9fe"
zinputFinal.Name="Final"
zinputFinal.Description=[[]]
zinputFinal.Visible=true
zinputFinal.Choices = {"Of course!", "Not yet. (Grrr)"}
zinputFinal.InputType="MultipleChoice"
zinputFinal.InputVariableId="30fe37a8-ae69-482a-ae53-e56cff1a0fb4"
zinputFinal.Text=[[Well? Sheesh! It's reflective! How hard can it be? Did you fing the dang thing or not?]]

--
-- Events/Conditions/Actions --
--

-------------------------------------------------------------------------------
------Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------

function zoneKiosk:OnEnter()
-- #GroupDescription=Kiosk --
-- #Comment=Kiosk Comment --
Wherigo.GetInput(zinputKiosk)
end

function zinputKiosk:OnGetInput(input)
Kiosk = input
-- #GroupDescription=Kiosk --
-- #Comment=Kiosk Comment --
if   Wherigo.NoCaseEquals(Kiosk,"Birding Trail") then
Wherigo.MessageBox{Text=[[Congratulations! Now the journey begins. Double check your gear, lock your car and pray for strength. You'll need it. Proceed to the first ammo can, at N 28° 41.182 / W 81° 8.839 The most scenic route involves heading east, following the woodline, till it turns south, entering the woods at the trail near the corner. Follow the trail, cross the footbridge, exit the woodline and go south to the river. Follow the trail east along the river, then go north as you near the zone. I've added a waypoint to the cache page at the easiest point to start your bushwhacking]],}
zoneAmmoCan1.Active = true
zoneAmmoCan1.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputKiosk)
end
end

function zoneAmmoCan1:OnEnter()
-- #GroupDescription=Ammo Can 1 --
-- #Comment=Ammo Can 1 Comment --
Wherigo.GetInput(zinputAmmoCan1)
end

function zoneTrailEnd1:OnEnter()
-- #GroupDescription=Trail End 1 --
-- #Comment=Trail End 1 Comment --
Wherigo.GetInput(zinputTrailEnd1)
end

function zinputAmmoCan1:OnGetInput(input)
AmmoCan1 = input
-- #GroupDescription=Ammo Can 1 --
-- #Comment=Ammo Can 1 Comment --
if   Wherigo.NoCaseEquals(AmmoCan1,"Holy Carp!") then
Wherigo.MessageBox{Text=[[Woot!! You got it! Normally, at this point in a Wherigo, you'd be able to see the next zone. But that would just be too easy, wouldn't it? So let's try something else. Shine your light on a bearing of 076* and you'll see a reflector trail. Follow the reflectors about 2/10 mile, till you see 3 reflectors set in a triangle. Pay attention to your Wherigo device as you go, because when you near the end of the trail the Trail End Zone will become visible, and from there you'll get further instructions]],}
zoneTrailEnd1.Active = true
zoneTrailEnd1.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputAmmoCan1)
end
end

function zoneAmmoCan2:OnEnter()
-- #GroupDescription=Ammo Can 2 --
-- #Comment=Ammo Can 2 Comment --
Wherigo.GetInput(zinputAmmoCan2)
end

function zinputTrailEnd1:OnGetInput(input)
TrailEnd1 = input
-- #GroupDescription=Trail End 1 --
-- #Comment=Trail End 1 Comment --
if   Wherigo.NoCaseEquals(TrailEnd1,"Wild Hog") then
Wherigo.MessageBox{Text=[[At this point, you should switch to your other GPSr, heading about 3/10 mile to the second ammo can at N28* 41.296 / W81* 08.351 You'll be doing some pure, unguided bushwhacking, with no reflectors to follow. You will probably cross another reflector trail along the way, which you can ignore for now. Keep following the little arrow on your GPSr till you find the ammo can. At that point, you can switch back to your Wherigo device. Make sure you keep your Wherigo device up and running, as you will trigger a zone at the next ammo can]],}
zoneAmmoCan1.Active = false
zoneAmmoCan1.Visible = false
zoneAmmoCan2.Active = true
zoneAmmoCan2.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputTrailEnd1)
end
end

function zoneTrailEnd2:OnEnter()
-- #GroupDescription=Trail End 2 --
-- #Comment=Trail End 2 Comment --
Wherigo.GetInput(zinputTrailEnd2)
end

function zinputAmmoCan2:OnGetInput(input)
AmmoCan2 = input
-- #GroupDescription=Ammo Can 2 --
-- #Comment=Ammo Can 2 Comment --
if   Wherigo.NoCaseEquals(AmmoCan2,"Yikes!") then
Wherigo.MessageBox{Text=[[Dude! You da man! (or other appropriate gender) From here, you'll follow the second reflector trail. Shine your light on a bearing of 274* to see the first reflector in the trail. Your trail will last about 2/10 mile. When you find three reflectors set in a triangle pattern, you will have reached the end of this trail, and you will trigger another zone which will guide you further along your quest. As with the first trail, you won’t be able to see the zone until you near the end of the trail
]],}
zoneTrailEnd1.Active = false
zoneTrailEnd1.Visible = false
zoneTrailEnd2.Active = true
zoneTrailEnd2.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputAmmoCan2)
end
end

function zoneAmmoCan3:OnEnter()
-- #GroupDescription=Ammo Can 3 --
-- #Comment=Ammo Can 3 Comment --
Wherigo.GetInput(zinputAmmoCan3)
end

function zinputTrailEnd2:OnGetInput(input)
TrailEnd2 = input
-- #GroupDescription=Trail End 2 --
-- #Comment=Trail End 2 Comment --
if   Wherigo.NoCaseEquals(TrailEnd2,"Rosie ODonnell") then
Wherigo.MessageBox{Text=[[Lets switch to your primary GPSr, heading about 3/10 mile to N28* 40.973 / W81* 08.659, as it's time for some more bushwhacking, with no reflectors to follow. You will probably cross another reflector trail along the way, which you can ignore for now. Keep following the little arrow on your GPSr till you find the ammo can. At that point, you can switch back to your Wherigo device. Make sure you keep your Wherigo device up and running, as you will trigger a zone at the next ammo can]],}
zoneAmmoCan2.Active = false
zoneAmmoCan2.Visible = false
zoneAmmoCan3.Active = true
zoneAmmoCan3.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputTrailEnd2)
end
end

function zoneTrailEnd3:OnEnter()
-- #GroupDescription=Trail End 3 --
-- #Comment=Trail End 3 Comment --
Wherigo.GetInput(zinputTrailEnd3)
end

function zinputAmmoCan3:OnGetInput(input)
AmmoCan3 = input
-- #GroupDescription=Ammo Can 3 --
-- #Comment=Ammo Can 3 Comment --
if   Wherigo.NoCaseEquals(AmmoCan3,"BR549") then
Wherigo.MessageBox{Text=[[Kewl! Great job solving that bugger! From here, you'll follow the third reflector trail. Shine your light on a bearing of 003* to see the first reflector in the trail. This trail will last about 2/10 mile, ending at three reflectors set in a triangle pattern. Keep your Wherigo device running, as once you reach the three reflectors you will trigger another zone. You will not be able to see the zone on your device until you near the end of the trail.
]],}
zoneTrailEnd2.Active = false
zoneTrailEnd2.Visible = false
zoneTrailEnd3.Active = true
zoneTrailEnd3.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputAmmoCan3)
end
end

function zoneAmmoCan4:OnEnter()
-- #GroupDescription=Ammo Can 4 --
-- #Comment=Ammo Can 4 Comment --
Wherigo.GetInput(zinputAmmoCan4)
end

function zinputTrailEnd3:OnGetInput(input)
TrailEnd3 = input
-- #GroupDescription=Trail End 3 --
-- #Comment=Trail End 3 Comment --
if   Wherigo.NoCaseEquals(TrailEnd3,"A Butt Load") then
Wherigo.MessageBox{Text=[[Brother, I never said it would be easy. Now you get to bushwhack, some more, without anything to guide your way except your GPSr. Head about 3/10 mile to N28* 41.381 / W81* 08.649, where you will find the fourth ammo can. You will probably cross another reflector trail along the way, which you can ignore for now. Once you get close to the ammo can you can switch back to your Wherigo device. as you will trigger a zone there]],}
zoneAmmoCan3.Active = false
zoneAmmoCan3.Visible = false
zoneAmmoCan4.Active = true
zoneAmmoCan4.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputTrailEnd3)
end
end

function zoneTrailEnd4:OnEnter()
-- #GroupDescription=Trail End 4 --
-- #Comment=Trail End 4 Comment --
Wherigo.GetInput(zinputTrailEnd4)
end

function zinputAmmoCan4:OnGetInput(input)
AmmoCan4 = input
-- #GroupDescription=Ammo Can 4 --
-- #Comment=Ammo Can 4 Comment --
if   Wherigo.NoCaseEquals(AmmoCan4,"OMG!") then
Wherigo.MessageBox{Text=[[Whoo Hoo!! You've nailed another one! Now it's time to follow reflectors again. Shine your light on a bearing of 140* and you will see the start of the fourth trail. Follow the reflectors for about 2/10 mile to a cluster of three reflectors, set in a triangle pattern. Make sure your Wherigo device is still running, as you will trigger another zone there]],}
zoneTrailEnd3.Active = false
zoneTrailEnd3.Visible = false
zoneTrailEnd4.Active = true
zoneTrailEnd4.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputAmmoCan4)
end
end

function zinputTrailEnd4:OnGetInput(input)
TrailEnd4 = input
-- #GroupDescription=Trail End 4 --
-- #Comment=Trail End 4 Comment --
if   Wherigo.NoCaseEquals(TrailEnd4,"Bureaucrat") then
Wherigo.MessageBox{Text=[[Holy Mackerel! You're still here? Now that's dedication! You'll notice that there are no more reflectors on this trail, and I assume you know by now what that means. More unguided bushwhacking! Head about 3/10 mile to N28* 41.044 / W81* 08.372, where you will find the fifth ammo can. You will probably cross another reflector trail along the way, which you can ignore for now. Once you get close to the ammo can you can switch back to your Wherigo device. as you will trigger a zone there]],}
zoneAmmoCan4.Active = false
zoneAmmoCan4.Visible = false
zoneAmmoCan5.Active = true
zoneAmmoCan5.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputTrailEnd4)
end
end

function zoneAmmoCan5:OnEnter()
-- #GroupDescription=Ammo Can 5 --
-- #Comment=Ammo Can 5 Comment --
Wherigo.GetInput(zinputAmmoCan5)
end

function zoneTrailEnd5:OnEnter()
-- #GroupDescription=Trail End 5 --
-- #Comment=Trail End 5 Comment --
Wherigo.GetInput(zinputTrailEnd5)
end

function zinputAmmoCan5:OnGetInput(input)
AmmoCan5 = input
-- #GroupDescription=Ammo Can 5 --
-- #Comment=Ammo Can 5 Comment --
if   Wherigo.NoCaseEquals(AmmoCan5,"Wazzup") then
Wherigo.MessageBox{Text=[[I know this quest seems endless, but you really are almost done! You've solved all 5 puzzles! You could quit right now and still feel a tremendous feeling of satisfaction. OK, OK, I know. You gotta get the smiley! Shine your light on a bearing of 300* and you will see the start of the fifth trail. Follow the reflectors for about 2/10 mile to a cluster of three reflectors, set in a triangle pattern. Make sure your Wherigo device is still running, as you will trigger another zone there]],}
zoneTrailEnd4.Active = false
zoneTrailEnd4.Visible = false
zoneTrailEnd5.Active = true
zoneTrailEnd5.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputAmmoCan5)
end
end

function zoneBacktoAmmoCan1:OnEnter()
-- #GroupDescription=Back to Ammo Can 1 --
-- #Comment=Back to Ammo Can 1 Comment --
Wherigo.GetInput(zinputBacktoAmmoCan1)
end

function zinputTrailEnd5:OnGetInput(input)
TrailEnd5 = input
-- #GroupDescription=Trail End 5 --
-- #Comment=Trail End 5 Comment --
if   Wherigo.NoCaseEquals(TrailEnd5,"Beer") then
Wherigo.MessageBox{Text=[[Brother, you should try out for the next season of Survivor! Seriously! Now that you have reached the end, you’ll have to go unguided from here. Bushwhack about 3/10 mile to N28* 41.182 / W81* 08.839, where you will find yourself right back where all this carp started, the first ammo can. You will probably cross another reflector trail along the way, which you can ignore for now. Once you get close to the ammo can you can switch back to your Wherigo device. as you will trigger a zone there]],}
zoneAmmoCan5.Active = false
zoneAmmoCan5.Visible = false
zoneBacktoAmmoCan1.Active = true
zoneBacktoAmmoCan1.Visible = true
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputTrailEnd5)
end
end

function zoneFinal:OnEnter()
-- #GroupDescription=Final --
-- #Comment=Final Comment --
Wherigo.GetInput(zinputFinal)
end

function zinputBacktoAmmoCan1:OnGetInput(input)
BacktoAmmoCan1 = input
-- #GroupDescription=Back to Ammo Can 1 --
-- #Comment=Back to Ammo Can 1 Comment --
if   Wherigo.NoCaseEquals(BacktoAmmoCan1,"This") then
Wherigo.MessageBox{Text=[[You should feel very proud. You have just completed the toughest 2.5 miles of bushwhacking on the planet! Whoo Hoo!!! That is freekin' awesome! Now all that's left is to locate the final, which should be pretty simple compared to what you just went through. Break out your traditional GPSr one more time, and proceed to N28* 41.283 / W81* 09.428 where you will find your well earned ammo can. If you had your track log enabled, just follow the track back toward the parking lot. The final will be just a little bit after you cross the foot bridge. If you wanna see something really kewl, take a look at your tracklog. Dude! You drew a freekin Pentacle! How kewl is that?
]],}
zoneFinal.Active = true
zoneFinal.Visible = true
zoneTrailEnd5.Active = false
zoneTrailEnd5.Visible = false
cartWherigoNightcaching:RequestSync()
else
Wherigo.GetInput(zinputBacktoAmmoCan1)
end
end

function zinputFinal:OnGetInput(input)
Final = input
-- #GroupDescription=Final --
-- #Comment=Final Comment --
if   Wherigo.NoCaseEquals(Final,"Of Course!") then
Wherigo.MessageBox{Text=[[Whoo Hoo!! You survived! Dude! You've earned the rank of Geocacher Extraordinaire! Film cans will tremble at your presence! Altoids Tins will quake in fear at the mention of your name! Ammo cans all across the globe will lust for your signature! Walk with Pride, Brother, you've earned it! Don't worry about any pesky unlock code. There isn't one. Just head home, pop the top off a cold one and log your adventure. Thanx for playing!]],}
cartWherigoNightcaching.Complete = true
else
Wherigo.GetInput(zinputFinal)
end
end
------End Builder Generated functions, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
------Builder Generated callbacks, Do not Edit, this will be overwritten------
-------------------------------------------------------------------------------
--#LASTCALLBACKKEY=0#--
------End Builder Generated callbacks, Do not Edit, this will be overwritten------
-- #Author Functions Go Here# --
-- #End Author Functions# --
-- Nothing after this line --
return cartWherigoNightcaching
